package inc.monsters.mias.data.statistics;

import inc.monsters.mias.data.Kid;
import inc.monsters.mias.data.facade.KidService;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import org.apache.myfaces.trinidad.model.ChartModel;

public class KidsScaredThisMonth extends ChartModel {
	private static final Logger log = Logger.getLogger("inc.monsters.mias");

	private KidService kidService;

	private List<List<Double>> data;
	private List<Kid> kids;

	public KidService getKidService() {
		return kidService;
	}

	public void setKidService(KidService kidService) {
		this.kidService = kidService;
	}

	public List<Kid> getKids() {
		if(null == kids) {
			kids = kidService.getKids();
		}
		return kids;
	}

	@SuppressWarnings("deprecation")
	private void calculate() {
		log.fine("calculate()");
		data = new ArrayList<List<Double>>();
		
		Date now = new Date();
		double kidsScared = 0.0;
		for(Kid kid: getKids()) {
			int year = kid.getLastScared().getYear();
			int month = kid.getLastScared().getMonth();
			
			if(year == now.getYear() && month == now.getMonth()) {
				kidsScared += 1.0;
			}
		}
		
		log.fine("Kids scared this month: " + kidsScared);
		
		List<Double> temp = new ArrayList<Double>();
		temp.add(kidsScared);
		data.add(temp);

		log.fine("bravenessData size: " + data.size());
		for(List<Double> list : data) {
			log.finer(" => " + list);
		}
	}
	
	@Override
	public List<String> getGroupLabels() {
		log.fine("getGroupLabels()");
		calculate();
		List<String> x = new ArrayList<String>();
		
		return x;
	}

	@Override
	public List<String> getSeriesLabels() {
		log.fine("getSeriesLabels()");
		calculate();
		List<String> x = new ArrayList<String>();
		x.add("Kids");
		return x;
	}

	@Override
	public List<List<Double>> getYValues() {
		log.fine("getYValues()");
		calculate();
		return data;
	}

	@Override
	public String getFootNote() {
		return super.getFootNote();
	}

	@Override
	public Double getMaxXValue() {
		return 100.0;
//		return super.getMaxXValue();
	}

	@Override
	public Double getMaxYValue() {
		return 120.0;
//		return super.getMaxYValue();
	}

	@Override
	public Double getMinXValue() {
		return 0.0;
//		return super.getMinXValue();
	}

	@Override
	public Double getMinYValue() {
		return 0.0;
//		return super.getMinYValue();
	}

	@Override
	public List<Color> getSeriesColors() {
		return super.getSeriesColors();
	}

	@Override
	public String getSubTitle() {
		return super.getSubTitle();
	}

	@Override
	public String getTitle() {
		return "Kids scared this month";
	}

	@Override
	public List<List<Double>> getXValues() {
		return super.getXValues();
	}
}